package gov.va.med.domain.service.messaging; 

import gov.va.med.domain.model.IPayload;
import gov.va.med.domain.model.PHRRequestPayload;
import gov.va.med.domain.model.Patient;
import gov.va.med.domain.model.RxRefillPayload;
import gov.va.med.domain.service.messaging.environment.DestinationKey;
import gov.va.med.framework.bean.ObjectHelper;

/**
 * DestinedRequest is a Request with destination, additional Patient keys 
 * and request Id keys.  It also provides some helper methods to pull values 
 * from it and its payload. 
 *
 * @author Slava Uchitel
 * @version $Id: DestinedRequest.java,v 1.10 2005/06/29 18:37:06 joel.goldberg Exp $
 * @since MHV 2.0 <br>03/18/2005
 */

public class DestinedRequest extends Request
{
    private static final long serialVersionUID = 3835156172671235639L;
    private DestinationKey destinationKey;
    private long patientRequestId;
    private long requestId;
    
    public DestinedRequest(DestinationKey aDestinationKey, 
						   MessageType messageType, 
						   IPayload payload) {
       super(messageType, payload);
       setDestinationKey(aDestinationKey);    
       
    }
	/**
	 * Returns the userid if explicitly set. 
	 * Otherwise dig out the user id from the paylaod 
	 * which is expected to be a PHRRequestPayload or Patient in this case. 
     * 
     * @throws ClassCastException if payload is not a PHRRequestPayload or Patient
	 */
    public long getUserId() {
		if (super.getUserId() == 0) {
			return getPatient().getLongId();
		}
		return super.getUserId();
    }
	/**
	 * Returns the icn by digging it dig out from the paylaod 
	 * which is expected to be a PHRRequestPayload in this case. 
     * @throws ClassCastException if payload is not a PHRRequestPayload or Patient
	 */
	public String getIcn () {
		return getPatient().getIcn();
	}
    /**
     * 
     * @throws ClassCastException if payload is not either a PHRRequestPayload 
     * or castable to Patient.  
     */
	protected Patient getPatient() {
	    /*if (getPayload().getClass().isAssignableFrom(PHRRequestPayload.class)) {
	    	return ((PHRRequestPayload)getPayload()).getPatient();
	    }*/
		
		//MJT - getting far too many ClassCastExceptions - adding payload checks - not just defaulting to Patient
		if(getPayload() instanceof RxRefillPayload)
		{
			RxRefillPayload rxp = (RxRefillPayload)getPayload();
			return rxp.getPatient();
		}
		if(getPayload() instanceof PHRRequestPayload)
		{
			PHRRequestPayload prxp = (PHRRequestPayload)getPayload();
			return prxp.getPatient();
		}		
		//default DomainObject type Patient
		return (Patient)getPayload();
	}
	
    public DestinationKey getDestinationKey()               { return destinationKey; }
    public void setDestinationKey(DestinationKey key)       { destinationKey = key;}
    public long getPatientRequestId()                    	{ return patientRequestId; }
    public void setPatientRequestId(long aRequestId)  		{ patientRequestId = aRequestId;}
    public long getRequestId()								{ return requestId; }
    public void setRequestId(long aRequestId)				{ requestId = aRequestId; }
    /**
     * If there is no Request Id, it is not tracked.  
     * If there is an ack required, it is not tracked. 
     */
    public boolean isTrackedRequest() {
        return  !(getRequestId() == 0 ||
        		  isApplicationAckRequest());
    }
    public String toString() {
         
        return super.toString() + 
        ObjectHelper.toAString(this);
    }
} 
